Moment_estimators = function(x){
n = length(x)
A1 = mean(x)
A2 = mean(x^2)
A4 = mean(x^4)

mu0_1 = A1
v0_1 = (-14/3 * A1^4 + 4 * A1^2 * A2 + 2 * A2^2 - 4/3 * A4) / (-2/3 * A1^4 + A2^2 - 1/3 * A4)
u0_1 = (-1/3 * (A2 - A1^2) * (5 * A1^4 - 6 * A1^2 * A2 + A4)) / (-7/3 * A1^4 + 2 * A1^2 * A2 + A2^2 - 2/3 * A4)

res = c(mu0_1, v0_1, u0_1)
}

Newtons = function(fun, p, x, ep=1e-5, it_max=20){
    index = 0; k = 1; p_moment = p
    while (k <= it_max){
        p1 = p; obj = fun(p, x)
        p  = p - solve(obj$J, obj$f)
		if (p[2] < 0 | p[3] < 0){
			cat("\n"); print(paste("p[2] < 0 | p[3] < 0, k = ", k, sep = "")); cat("\n")
			cat("\n"); print(paste("p[1] = ", round(p[1], 3), ", p[2] = ", round(p[2], 3), ", p[3] = ", round(p[3], 3), sep = "")); cat("\n")
			p = p_moment
			index = 2
			break
		}
		
		if (p[2] > 100 | p[3] > 100){
			cat("\n"); print(paste("p[2] > 100 | p[3] > 100, k = ", k, sep = "")); cat("\n")
			cat("\n"); print(paste("p[1] = ", round(p[1], 3), ", p[2] = ", round(p[2], 3), ", p[3] = ", round(p[3], 3), sep = "")); cat("\n")
			p = p_moment
			index = 3
			break
		}
		
        norm = sqrt((p-p1) %*% (p-p1))
        if (norm < ep){
            index = 1; break
        }
        k = k + 1
    }
    obj = fun(p, x);
    list(root=p, it=k, index=index, FunVal=obj$f)
}

moment_fun = function(p, x){
mu0 = p[1]
v0 = p[2]
u0 = p[3]
g = v0 * u0 + (x - mu0)^2

f1 = mean((v0 + 1) * (x - mu0) / g)
# f2 = 1/2 * digamma((v0 + 1) / 2) - 1/2 * digamma(v0 / 2) - 1 / (2 * v0) - 1/2 * mean(log(g) - log(v0 * u0) - (v0 + 1) * (g - v0 * u0) / (g * v0))
f2 = 1/2 * digamma((v0 + 1) / 2) - 1/2 * digamma(v0 / 2) - 1 / (2 * v0) - 1/2 * mean(log(g / (v0 * u0)) - (v0 + 1) * (g - v0 * u0) / (g * v0))
f3 = - 1 / (2 * u0) + 1/2 * mean((v0 + 1) * (g - v0 * u0) / (g * u0))
f = c(f1, f2, f3)

J11 = mean((v0 + 1) * (g - 2 * v0 * u0) / g^2)
J12 = mean((x - mu0) * (g - v0 * u0 - u0) / g^2)
J13 = - mean(v0 * (v0 + 1) * (x - mu0) / g^2)
J21 = J12
J22 = 1/4 * trigamma((v0 + 1) / 2) - 1/4 * trigamma(v0 / 2) + 1 / (2 * v0^2) + 1/2 * mean((g - v0 * u0) * (g * (v0 - 1) - u0 * v0 * (v0 + 1)) / (g^2 * v0^2))
J23 = 1/2 * mean((g - v0 * u0) * (g - v0 * u0 - u0) / (g^2 * u0))
J31 = J13
J32 = J23
J33 = 1 / (2 * u0^2) - 1/2 * mean((v0 + 1) * (g^2 - v0^2 * u0^2) / (g^2 * u0^2))
J = matrix(c(J11, J12, J13,
			 J21, J22, J23,
			 J31, J32, J33), nrow=3, byrow = TRUE)
			 
res = list(f=f, J=J)
}

data_outline = function(x){
   n = length(x)
   m = mean(x)
   v = var(x)
   s = sd(x)
   me = median(x)
   cv = 100*s/m
   css = sum((x-m)^2)
   uss = sum(x^2)
   R =  max(x)-min(x)
   R1 = quantile(x, 3/4)-quantile(x, 1/4)
   sm = s/sqrt(n)
   g1 = n/((n-1)*(n-2))*sum((x-m)^3)/s^3
   g2 = ((n*(n+1))/((n-1)*(n-2)*(n-3))*sum((x-m)^4)/s^4
          - (3*(n-1)^2)/((n-2)*(n-3)))
   data.frame(N=n, Mean=m, Var=v, std_dev=s, Median=me, 
        std_mean=sm, CV=cv, CSS=css, USS=uss, R=R, 
        R1=R1, Skewness=g1, Kurtosis=g2, row.names=1)
}


Marginal_density_mu0_v0_u0 = function(x, mu0, v0, u0){
res = gamma((v0 + 1) / 2) / (gamma(v0 / 2) * sqrt(pi * v0 * u0)) * (1 + (x - mu0)^2 / (v0 * u0))^(-(v0 + 1) / 2) 
}

Marginal_density_hyperparameters = function(x, mu0, k0, v0, sigma0){
res = gamma((v0 + 1) / 2) / (gamma(v0 / 2) * sqrt(pi * v0 * sigma0^2 * (k0 + 1) / k0)) * (1 + (x - mu0)^2 / (v0 * sigma0^2 * (k0 + 1) / k0))^(-(v0 + 1) / 2) 
}

p_N_NIG_mu0_v0_u0 = function(x, mu0, v0, u0){

Marginal_density = function(x){
res = gamma((v0 + 1) / 2) / (gamma(v0 / 2) * sqrt(pi * v0 * u0)) * (1 + (x - mu0)^2 / (v0 * u0))^(-(v0 + 1) / 2)
}
	
L_x = length(x)
I_value = I_abs_error = numeric(L_x)
for (i in 1:L_x){
	I_i = integrate(f = Marginal_density, lower = - Inf, upper = x[i])
	I_value[i] = I_i$value
	I_abs_error[i] = I_i$abs.error
}

res = I_value
}

Compute_Proportions_vector_pmin = function(v1, v2, v3){
min_v = pmin(v1, v2, v3)
Proportions = numeric(3)
Proportions[1] = mean(v1 == min_v) 
Proportions[2] = mean(v2 == min_v) 
# Proportions[3] = mean(v3 == min_v) 
Proportions[3] = 1 - Proportions[1] - Proportions[2] # to avoid several minimums

res = Proportions
}

Compute_Proportions_vector_pmax = function(v1, v2, v3){
max_v = pmax(v1, v2, v3)
Proportions = numeric(3)
Proportions[1] = mean(v1 == max_v) 
Proportions[2] = mean(v2 == max_v) 
# Proportions[3] = mean(v3 == max_v) 
Proportions[3] = 1 - Proportions[1] - Proportions[2] # to avoid several maximums

res = Proportions
}

Compute_PostDist_Estimators_PESLs_new = function(mu0, k0, v0, sigma0, x_np1){
alpha1 = (v0 + 1) / 2
beta1 = 1/2 * (v0 * sigma0^2 + k0 / (k0 + 1) * (x_np1 - mu0)^2)

PostDist_theta = 1 / rgamma(n = 1e4, shape = alpha1, rate = beta1)
delta_s = beta1 / alpha1
delta_2 = beta1 / (alpha1 - 1)
PESL_s = log(alpha1) - digamma(alpha1)
PESL_2 = 1 / (alpha1 - 1) + log(alpha1 - 1) - digamma(alpha1)

res = list(
PostDist_theta = PostDist_theta,
delta_s = delta_s, 
delta_2 = delta_2, 
PESL_s = PESL_s,
PESL_2 = PESL_2
)
}

Compute_Estimators_PESLs_new = function(mu0, k0, v0, sigma0, x_np1){
alpha1 = (v0 + 1) / 2
beta1 = 1/2 * (v0 * sigma0^2 + k0 / (k0 + 1) * (x_np1 - mu0)^2)

delta_s = beta1 / alpha1
delta_2 = beta1 / (alpha1 - 1)
PESL_s = log(alpha1) - digamma(alpha1)
PESL_2 = 1 / (alpha1 - 1) + log(alpha1 - 1) - digamma(alpha1)

res = list(
delta_s = delta_s, 
delta_2 = delta_2, 
PESL_s = PESL_s,
PESL_2 = PESL_2
)
}

Compute_mean_variance = function(mu0, v0, u0){
E = mu0
V = v0 / (v0 - 2) * u0

res = data.frame(Expectation = E, Variance = V)
}

Generate_Matrix_Latex = function(A){
m = nrow(A)
n = ncol(A)

C = rep("c", n, sep=""); C
temp = "[c]{"
for (i in 1:n){
temp = paste(temp, C[i], sep="")
}
temp = paste(temp, "}", sep="")

B = matrix("0", nrow = m, ncol = 2*n); B
for (i in 1:m){
	for (j in 1:n){
		B[i, 2*j-1] = A[i, j]
		B[i, 2*j]   = "&"
	}
}
B[, 2*n] = "\\\\"
B[m, 2*n] = ""
B

One = "\\begin{tabular}"
Two = temp
Three = B
Four = "\\end{tabular}"

cat(One, "\n", Two, "\n"); for (i in 1:m) cat(B[i, ], "\n");  cat(Four, "\n")
}

plot_estimator = function(delta_s, delta_2, parameter, para_name, xlab, legend_pos = "topleft", sub){
dev.new()
col = c("blue", "red")
lty = 1:2
xlim = range(parameter)
ylim = range(delta_s, delta_2)
#ylim=c(0:1)
plot(parameter, delta_s, type = "n", xlim = xlim, ylim = ylim, xlab = xlab, ylab = "Estimator", sub = sub)
lines(parameter, delta_s, lty = lty[1], col = col[1], lwd = 4)
lines(parameter, delta_2, lty = lty[2], col = col[2], lwd = 4)
leg.txt = c("delta_s", "delta_2")
legend(x = legend_pos, legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/N-NIG_Estimator_", para_name, "_change", sep = ""), type = c("pdf"))
savePlot(filename = paste("figure/N-NIG_Estimator_", para_name, "_change", sep = ""), type = c("jpg"))
}

plot_PESL = function(PESL_s, PESL_2, parameter, para_name, xlab, legend_pos = "topleft", sub){
dev.new()
col = c("blue", "red")
lty = 1:2
xlim = range(parameter)
ylim = range(PESL_s, PESL_2)
plot(parameter, PESL_s, type = "n", xlim = xlim, ylim = ylim, xlab = xlab, ylab = "PESL", sub = sub)
lines(parameter, PESL_s, lty = lty[1], col = col[1], lwd = 4)
lines(parameter, PESL_2, lty = lty[2], col = col[2], lwd = 4)
leg.txt = c("PESL_s", "PESL_2")
legend(x = legend_pos, legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/N-NIG_PESL_", para_name, "_change", sep = ""), type = c("pdf"))
savePlot(filename = paste("figure/N-NIG_PESL_", para_name, "_change", sep = ""), type = c("jpg"))
}
